<?php
require_once __DIR__ . '/../includes/auth.php';
require_login();

/* -------- page config -------- */
$page_title = 'Operations';
ob_start();
?>
<link rel="stylesheet" href="/adminconsole/assets/ui.css">
<div class="master-wrap">
  <div class="headbar">
    <h2 style="margin:0"><?=htmlspecialchars($page_title)?></h2>
  </div>

  <div class="card" style="margin-bottom:14px">
    <form method="get" class="toolbar" style="gap:10px; display:flex; flex-wrap:wrap; align-items:center">
      <input class="inp" type="text" name="q" value="<?=htmlspecialchars($_GET['q'] ?? '')?>" placeholder="Search pages..." style="min-width:240px">
      <button class="btn primary" type="submit">Search</button>
      <a class="btn secondary" href="?">Reset</a>
    </form>
  </div>

  <div class="table-wrap" style="padding:0; background:transparent; border:none">
    <div class="grid" style="display:grid; grid-template-columns:repeat(auto-fill,minmax(260px,1fr)); gap:14px">
      <?php
      // -------- helpers --------
      function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
      function humanize($fname){
        $n = preg_replace('/\.php$/i','', $fname);
        $n = str_replace(['_','-'],' ', $n);
        return ucwords($n);
      }
      function extract_title($path){
        // Try to read first ~8KB to find $page_title
        $fh = @fopen($path,'r');
        if(!$fh) return null;
        $chunk = '';
        $max = 8192;
        while(!feof($fh) && strlen($chunk)<$max){
          $chunk .= fread($fh, 1024);
        }
        fclose($fh);
        if (preg_match('/\$page_title\s*=\s*[\'"](.+?)[\'"]\s*;?/i', $chunk, $m)) {
          return trim($m[1]);
        }
        // Try an <h2> or <h3> tag as a fallback (in case of standalone render)
        if (preg_match('/<h[23][^>]*>([^<]+)<\/h[23]>/i', $chunk, $m2)) {
          return trim(strip_tags($m2[1]));
        }
        return null;
      }

      // -------- scan directory --------
      $dir = __DIR__; // /adminconsole/operations
      $files = glob($dir . '/*.php');
      $cards = [];

      foreach ($files as $path) {
        $base = basename($path);
        if (strtolower($base) === 'index.php') continue; // skip this file

        $title = extract_title($path) ?: humanize($base);
        $desc  = 'Open and manage: ' . $title;

        // Build URL relative to /adminconsole/operations/
        $url = '/adminconsole/operations/' . rawurlencode($base);

        // Apply search filter if any
        $q = trim($_GET['q'] ?? '');
        if ($q !== '') {
          $hay = mb_strtolower($title . ' ' . $base);
          if (mb_strpos($hay, mb_strtolower($q)) === false) continue;
        }

        // Prefer "Open" button label; allow custom hint for well-known files
        $hint = 'Open';
        $cards[] = [
          'title' => $title,
          'desc'  => $desc,
          'url'   => $url,
          'hint'  => $hint,
          'mtime' => @filemtime($path) ?: 0,
          'fname' => $base,
        ];
      }

      // Sort by recent modified first
      usort($cards, function($a,$b){ return $b['mtime'] <=> $a['mtime']; });

      // If empty, show a friendly note
      if (empty($cards)) {
        echo '<div class="card"><div class="alert warn">No operation pages found in this folder.</div></div>';
      } else {
        // Optional: show one sample (already in your snippet)
        ?>
      
        <?php
        // Render discovered cards
        foreach ($cards as $c){
          ?>
          <div class="card">
            <h3 style="margin:0 0 6px"><?=h($c['title'])?></h3>
            <p style="margin:0 0 10px;color:#9ca3af"><?=h($c['desc'])?></p>
            <a class="btn" href="<?=h($c['url'])?>"><?=h($c['hint'])?></a>
            <div style="margin-top:8px;font-size:12px;color:#94a3b8">File: <?=h($c['fname'])?></div>
          </div>
          <?php
        }
      }
      ?>
    </div>
  </div>
</div>
<?php
echo ob_get_clean();
